#pragma rtGlobals=1		// Use modern global access method.



Menu "WaveCalculator"
"Wave add Wave" 
"Wave subtract Wave"
"Wave multiply Wave"
"Wave divided by  Wave"
"-"
"Wave add value"
"Wave  subtract value"
"Wave multiply value"
"Wave divided by value"
"-"
"Average waves"
"Average across folders"

"Image Operator"
"Seperate a column from data"
end


Proc WaveaddWave(wave1,wave2)
        STRING wave1,wave2
        Prompt Wave1, "enter the first wave",popup, wavelist("*",";","")
        Prompt Wave2, "enter the second wave",popup,wavelist("*",";","")
	if(DimSize($Wave1,0) == DimSize($Wave2,0))
		WaveCalculatorW(0, $Wave1,$Wave2)
	else
	endif 
End

Proc WavesubtractWave(wave1,wave2)
        STRING wave1,wave2
        Prompt Wave1, "enter the first wave",popup, wavelist("*",";","")
        Prompt Wave2, "enter the second wave",popup, wavelist("*",";","")
	if(DimSize($Wave1,0) == DimSize($Wave2,0))
		WaveCalculatorW(1, $Wave1,$Wave2)
	else
	endif 
End

Proc WavemultiplyWave(wave1,wave2)
        STRING wave1,wave2
        Prompt Wave1, "enter the first wave",popup, wavelist("*",";","")
        Prompt Wave2, "enter the second wave",popup, wavelist("*",";","")
	if(DimSize($Wave1,0) == DimSize($Wave2,0))
		WaveCalculatorW(2, $Wave1,$Wave2)
	else
	endif 
End

Proc WavedividedbyWave(wave1,wave2)
        STRING wave1,wave2
        Prompt Wave1, "enter the divided wave",popup,wavelist("*",";","")
        Prompt Wave2, "enter the dividing wave",popup, wavelist("*",";","")
	if(DimSize($Wave1,0) == DimSize($Wave2,0))
		WaveCalculatorW(3, $Wave1,$Wave2)
	else
	endif 
End

Proc Waveaddvalue(wave1,value)
        STRING wave1
        string wavenames = wavelist("*",";","")
        VARIABLE value
        Prompt Wave1, "enter the wave",popup, wavenames
        Prompt value, "enter the value"
	  WaveCalculatorV(0, value,$Wave1)
End

Proc Wavesubtractvalue(wave1,value)
        STRING wave1
        string wavenames = wavelist("*",";","")
        VARIABLE value
        Prompt Wave1, "enter the wave",popup, wavenames
        Prompt value, "enter the value"
	  WaveCalculatorV(1, value,$Wave1)
End

Proc Wavemultiplyvalue(wave1,value)
        STRING wave1
        string wavenames = wavelist("*",";","")
        VARIABLE value
        Prompt Wave1, "enter the wave",popup, wavenames
        Prompt value, "enter the value"
	  WaveCalculatorV(2, value,$Wave1)
End

Proc Wavedividedbyvalue(wave1,value)
        STRING wave1
        string wavenames = wavelist("*",";","")
        VARIABLE value
        Prompt Wave1, "enter the wave",popup, wavenames
        Prompt value, "enter the value"
	  WaveCalculatorV(3, value,$Wave1)
End

proc averagewaves(keyword)
	string keyword
	Prompt keyword,"the indexed words for waves"
	WaveAvg(keyword)
end

Window Averageacrossfolders() : Panel
	PauseUpdate; Silent 1		// building window...
	NewPanel /W=(1165,177,1437,344)
	ModifyPanel frameStyle=4, frameInset=3
	PopupMenu folder1,pos={14,15},size={242,21},bodyWidth=111,title="Select one data folder        ",mode=3,popvalue="Slice0",value= #"ListFolder()"
	PopupMenu folder2,pos={14,68},size={242,21},bodyWidth=111,title="Select the other data folder",mode=4,popvalue="Slice1",value= #"ListFolder()"
	SetVariable keyword1,pos={15,44},size={242,16},title="Keyword of waves in 1st folder",fSize=12,value= _STR:""
	SetVariable keyword2,pos={15,98},size={242,16},title="Keyword of waves in 2nd folder",fSize=12,value= _STR:""
	Button FolderAvg,pos={14,122},size={244,30},proc=MultiFolderAvg,title="Average"
	
EndMacro


Window ImageOperator():Panel
	NewPanel /W=(1351,257,1627,454)
EndMacro


Function/S ListFolder()
	STRING folderlist=""	
	STRING FolderDir=DataFolderDir(1)
	variable i
	
	For(i=0;i<ItemsInList(FolderDir,",");i+=1)
		FolderList= FolderList+";"+stringfromlist(i,FolderDir,",")
	endfor
	
	
	FolderList=Replacestring(";FOLDERS:", FolderList,"")
	
	
	return Folderlist
end

Function/WAVE WaveCalculatorW(Operator, FileName1,FileName2)
	VARIABLE Operator
	Wave FileName1,FileName2

	if(wavedims(FileName1)==3 && WaveDims(FileName2)==2)
			variable i
			for(i=0;i<DimSize(FileName1,2);i+=1)
				duplicate/R=[][][i,i] FileName1,w
				redimension/N=(-1,-1,0) w 
				Switch(Operator)
				Case 0:
					w = w+FileName2
					Break
				Case 1:
					w = w-FileName2
					Break
				Case 2:
					w = w*FileName2
					Break
				Case 3:
					w = w/FileName2
					Break				
			EndSwitch
			concatenate/NP=2/KILL {w},solution
		endfor
	elseif(wavedims(FileName1)==WaveDims(FileName2))
		Duplicate/O FileName1,Solution
		Switch(Operator)
			Case 0:
				Solution = FileName1+FileName2
				Break
			Case 1:
				Solution = FileName1-FileName2
				Break
			Case 2:
				Solution = FileName1*FileName2
				Break
			Case 3:
				Solution = FileName1/FileName2
				Break				
		EndSwitch	
	endif	
	
	return Solution

End

Function WaveCalculatorV(Operator, num, FileName)
	VARIABLE Operator, Num
	Wave FileName

		
		Switch(Operator)
			Case 0:
				FileName = FileName+num
				Break
			Case 1:
				FileName = FileName-num
				Break
			Case 2:
				FileName = FileName*num
				Break
			Case 3:
				FileName = FileName/num
				Break				
		EndSwitch	




End


Function WaveCut (F_int, FileName)
	VARIABLE F_int
	Wave FileName
	
	variable i,j
	String WaveNam= NameOfWave(FileName)

	
	j=0
	For(i=0;i<DimSize(FileName,0);i+=F_int)
		String Name = Wavenam+num2str(j)
		Make/O $Name
		Duplicate/O/R=[i-1,i+F_int] FileName, $Name	
		j=j+1

	Endfor
End


function statable()

	wave dFoF0_neural,dFoF0_abneural
	make/n=2 dFoF0_AVG
	make/n=2 dFoF0_SD
	make/n=2 dFoF0_SEM
	make/T/n=2 name
	name[0]="neural"
	name[1]="abneural"
	
	wavestats dFoF0_neural
	dFoF0_AVG[0]=V_avg
	dFoF0_SD[0]=V_sdev
	dFoF0_SEM[0]=V_sem
	
	wavestats dFoF0_abneural
	dFoF0_AVG[1]=V_avg
	dFoF0_SD[1]=V_sdev
	dFoF0_SEM[1]=V_sem	
end

Function/Wave Partial3DWaveAvg(w,L1,L2)
	wave w
	variable L1,L2
	
	variable i
	
	make/n=(Dimsize(w,0),DimSize(w,1)) SumWave	
		
	for(i=L1;i<=L2;i+=1)
		duplicate/O/R=[][][i,i] w, tempwave
		Redimension/N=(-1,-1,0) tempwave
		SumWave = SumWave+ TempWave
	endfor
	killwaves Tempwave
	SumWave = SumWave/(abs(L2-L1)+1)
	Rename SumWave, AvgWave

	return AvgWave
end

Function DFavgin3Dwave(wN,rBg,rEn,sBg,sEn)
	STRING wN; VARIABLE rBg,rEn,sBg,sEn
	
	wave Imw=$wN
	
	variable i
	string NewName="DF_"+NameOfWave(imw)
	
	make/n=(DimSize(Imw,0),DimSize(Imw,1)) avgrWave,avgsWave
	for(i=rBg;i<=rEn;i+=1)
		duplicate/O/R=[][][i,i] Imw, TempW
		redimension/n=(-1,-1,0) TempW
		avgrWave=avgrWave+TempW
	endfor
		avgrWave=avgrWave/(rEn-rBg+1)
	
	for(i=sBg;i<=sEn;i+=1)
		duplicate/O/R=[][][i,i] Imw, TempW
		redimension/n=(-1,-1,0) TempW
		avgsWave=avgsWave+TempW
	endfor
		avgsWave=avgsWave/(sEn-sBg+1)
		
		avgsWave=avgsWave-avgrWave
		killwaves avgrWave,TempW
		rename avgsWave, $NewName	
end

Function RepeatDF3DWave()
	string aW=wavelist("TL*.tif",";","")
	variable i
	
	for(i=1;i<itemsInList(aW);i+=1)
		DFavgin3Dwave(stringfromlist(i,aw),1,9,10,49)
	endfor
	
end

Function WaveAvg(str)
	string str
	variable L1,L2
	
	variable i
	string Aw=wavelist(str,";","")
	
	duplicate/O $stringfromlist(i,Aw), SumWave	
		
	for(i=1;i<ItemsInList(Aw);i+=1)
		duplicate/O $stringfromlist(i,Aw), tempwave		
		SumWave = SumWave+ TempWave
	endfor
	killwaves Tempwave
	SumWave = SumWave/(ItemsInList(Aw))
	Rename SumWave, AvgWave

end

Function/Wave AvgIn3Dwave(Z0,Z1,w)
		variable Z0,Z1; Wave w
		
		variable i
		Duplicate/R=[][][Z0,Z0] w, w_avg
		for(i=1;i<=Z1-Z0;i+=1)
			duplicate/R=[][][i+Z0,i+Z0]/O w, w_temp
			w_avg=w_avg+w_temp
		endfor
		killwaves w_temp
		w_avg=w_avg/(Z1-Z0+1)
		redimension/N=(-1,-1,0) w_avg
		string newname="Avg_"+NameofWave(w)
		rename w_avg, $NewName
		
		return w_avg
end

Function WaveSEM(str)
	string str
	variable L1,L2
	
	variable i=0
	string Aw=wavelist(str,";","")
	
	duplicate/O $stringfromlist(i,Aw), SumWave	
		
	for(i=1;i<ItemsInList(Aw);i+=1)
		duplicate/O $stringfromlist(i,Aw), tempwave		
		SumWave = SumWave+ TempWave
	endfor
	killwaves Tempwave
	SumWave = SumWave/(ItemsInList(Aw))
	Rename SumWave, AvgWave
	wave AvgWave
	
	duplicate/O $stringfromlist(0,Aw), Sum2Wave
	Sum2Wave = Sum2Wave*Sum2Wave
		
	for(i=1;i<ItemsInList(Aw);i+=1)
		duplicate/O $stringfromlist(i,Aw), tempwave		
		TempWave = TempWave*TempWave
		Sum2Wave= Sum2Wave+TempWave
	endfor
	killwaves TempWave
	Sum2Wave=Sum2Wave/(i-1)
	Sum2Wave=sqrt(Sum2Wave-AvgWave*AvgWave)/sqrt(i)
	Rename Sum2Wave, SEMWave

end

Function MultiFolderAvg(FolderAvg):Buttoncontrol
	STRING FolderAvg
	
	ControlInfo Folder1
	String F1=S_Value
	ControlInfo Folder2
	String F2=S_Value
	ControlInfo keyword1
	String KeyC1=S_Value
	ControlInfo keyword2
	String KeyC2=S_Value  
	print F1,F2,keyC1,keyC2
	
	String NewFolderName=F1+"_"+F2
	String F1Waves,F2Waves
	DFREF CurrentDFR=GetDataFolderDFR()
	
	setdatafolder $F1
	F1Waves=Wavelist(KeyC1,";","")
	setdatafolder CurrentDFR
	
	setdatafolder $F2
	F2Waves=Wavelist(KeyC2,";","")
	setdatafolder CurrentDFR
	
	if(ItemsInlist(F1Waves) != ItemsInlist(F2Waves))
		print "wave number not equal !!"
	else
		variable i,p,q
		string NewNameRef
		string NewName
		DuplicateDataFolder $F1, :test1
		DuplicateDataFolder $F2, :test2
	
		for(i=0;i<itemsinlist(F1Waves);i+=1)
			movewave :test2:$StringFromList(i,F2waves), :test1:
		endfor
		
		if(stringmatch(keyC1,"TLFV*")==1 || stringmatch(keyC2,"TLFV*")==1)
			NewNameRef = "TLAvg_"
		else
			NewNameRef = "TLFV_"
		endif
		
		setdatafolder test1
		for(i=0;i<itemsinlist(F1Waves);i+=1)
			wave wF1 = $stringfromlist(i,F1Waves,";")
			wave wF2 = $stringfromlist(i,F2Waves,";")
			Redimension/S wF1,wF2
			make/O/n=(DimSize(wF1,0),DimSize(wF1,1)) Ans
			Ans = (wF1+wF2)/2
			NewName=NewNameRef+num2str(i)
			rename Ans, $NewName
			KillWaves wF1,wF2
		endfor
	endif
	
	
	
	SetDataFolder CurrentDFR
	killDataFolder test2
	RenameDataFolder test1, $NewFolderName	
	

end

Function/Wave ImageCalculation(Image1,Image2,operator)
	STRING Image1,Image2
	VARIABLE operator
	
	wave edWave=$Image1
	wave ingWave=$Image2
	
	if(WaveDims(edWave) != WaveDims(ingWave) || DimSize(edWave,0) != DimSize(ingWave,0) || DimSize(edWave,1) != DimSize(ingWave,1))
		return Nan
	else
		variable p,q
		Make/O/n=(DimSize(edwave,0),DimSize(edwave,1)) NewWave
		
		Switch(Operator)
			Case 0:
				for(p=0;p<DimSize(edwave,0);p+=1)
					for(q=0;q<DimSize(edwave,1);q+=1)
						NewWave[p][q]=ingWave[p][q]+edWave[p][q]
					endfor	
				endfor	
				Break
			Case 1:
				for(p=0;p<DimSize(edwave,0);p+=1)
					for(q=0;q<DimSize(edwave,1);q+=1)
						NewWave[p][q]=ingWave[p][q]-edWave[p][q]
					endfor	
				endfor
				Break
			Case 2:
				for(p=0;p<DimSize(edwave,0);p+=1)
					for(q=0;q<DimSize(edwave,1);q+=1)
						NewWave[p][q]=ingWave[p][q]*edWave[p][q]
					endfor	
				endfor
				Break
			Case 3:
				for(p=0;p<DimSize(edwave,0);p+=1)
					for(q=0;q<DimSize(edwave,1);q+=1)
						NewWave[p][q]=ingWave[p][q]/edWave[p][q]
					endfor	
				endfor
	
				Break				
		EndSwitch
				
	Return NewWave 
	
	endif 
	

end

//Calculating the Rs-corrected Vmon, and resampling this corrected Vmon as camera sampling rate
//NoS is the No. of spot, CLayer is its layer
function RsCorrectVclamper(NoS,CLayer)
	VARIABLE CLayer,NoS //index:0, without Rs compensation, 1: with	
	
	DFREF home=getdatafolderdfr()
	setdatafolder CaTraces
	string foldername="Slice"+num2str(CLayer)
	string TargetFolderList=ListFolder()
	string targetfolder="Spot"+num2str(Nos)
	variable n=0
//	do
//		cmpr=stringfromList(n,targetfolderlist,";")
//		n=n+1
//	while(stringmatch(cmpr,targetfolder)!=1)
	setdatafolder $targetfolder
	DFREF target=getdatafolderdfr()
	setdatafolder home
	setdatafolder :$FolderName
	
	string Imons=wavelist("PDep*1",";","")
	string Vmons=wavelist("PDep*2",";","")
	string MVmonName,wavenote,Rseries
	variable Rs
	variable i,j,k=-1
	
	for(i=0;i<ItemsInList(Imons);i+=1)
		wave Imon=$StringFromList(i,Imons,";")
		wavenote=note(Imon)
		
		Rseries=stringbykey("\rRsValue",wavenote)
		Rs=str2num(Rseries)*10^6
		
		if(Rs==0)
			Rseries=stringbykey("\rRSeries",wavenote)
			Rs=str2num(Rseries)*10^6					
		endif

		wave Vmon=$StringFromList(i,Vmons,";")
		make/O/n=(DimSize(Vmon,0)) TempVmon
		TempVmon=Vmon+Imon*Rs
		MVmonName="VmonSlow"
		setscale/P x 0,deltax(Vmon), TempVmon
		make/O/n=0 TempRe 
		for(j=0;j<Dimsize(TempVmon,0);j+=0.005/deltax(Vmon))
			k=k+1
			Insertpoints/M=0 DimSize(TempRe,0),1,TempRe
			TempRe[k]=TempVmon[j]	
		endfor
		setscale/P x 0,0.005, TempRe
		Duplicate Imon,ImonTemp
		movewave ImonTemp,target
		movewave TempRe, target
		movewave TempVmon,target		
		setdatafolder target
		if(waveexists($MVmonName)==1)
			killwaves $MVmonName
		endif
			rename TempRe, $MVmonName
		MVmonName="VmonCor"
		if(waveexists($MVmonName)==1)
			killwaves $MVmonName
		endif		
		rename TempVmon,  $MVmonName
//		if(waveexists(Imon)==1)
//			killwaves ImonTemp
//		else
			rename ImonTemp, $NameOfWave(Imon)
//		endif
		setdatafolder home	
	endfor	
	
end







Function CaProfileOutput()
	DFREF home=getdatafolderdfr()
	
	string AFolder=ListFolder()
	string allwaves
	string wn,Single="Avg_"+"*"
	variable point0,point1,point2,i,j,k
	
	
	make/O/n=(ItemsInList(AFolder)-1,5) CaProfile
	for(i=0;i<ItemsInList(AFolder)-1;i+=1)	
		setdatafolder  :$StringFromList(i,AFolder):
		allwaves=wavelist("*",";","")
		for(k=5;k<ItemsInList(allwaves);k+=1)
			killwaves/Z $stringfromlist(k,allwaves)
		endfor
		setdatafolder home
		Movewave CaProfile, :$StringFromList(i,AFolder):
		setdatafolder  :$StringFromList(i,AFolder):
		wave VSlow=$stringfromlist(0,wavelist("VmonS*","",""))
		j=0
		
		do 
			j=j+1	
		while(Vslow[j]<-0.07 && i<DimSize(VSlow,0))
		Point0=j
		
		do 
			j=j+1	
		while(Vslow[j]<0.005 && j<DimSize(VSlow,0))
		Point1=j

		do 
			j=j+1	
		while(Vslow[j]<0.015 && j<DimSize(VSlow,0))	
		point2=j
	
		wn=wavelist(single,";","")
		BoltzmannFV()                    //***//
		wave W_Coef,W_Sigma
		CaProfile[i][2]=W_Coef[2]
		CaProfile[i][3]=W_Coef[3]
		CaProfile[i][4]=W_Sigma[2]
		
		wave FV=$stringfromlist(0,wn)
		wavestats/R=[point1,point2] FV
		CaProfile[i][0]=V_avg

		wave fit_FVTru
		wavestats fit_FVTru
		CaProfile[i][1]=V_max
		
		wavestats/R=[point0,point0+4] FV
		CaProfile[i][0]=CaProfile[i][0]-V_avg
		CaProfile[i][1]=CaProfile[i][1]-V_avg
		movewave CaProfile,home
		setdatafolder home
	endfor

end













Window Seperateacolumnfromdata() : Panel
	PauseUpdate; Silent 1		// building window...
	NewPanel /W=(432,482,704,574)
	ModifyPanel frameStyle=2
	PopupMenu DPool,pos={11,8},size={140,21},title="Data pool:",font="Arial"
	PopupMenu DPool,fSize=14
	PopupMenu DPool,mode=1,popvalue="RbProfile",value= #"WaveList(\"*\",\";\",\"Dims:2\")"
	SetVariable RowNr,pos={161,8},size={95,20},title="Row No.",font="Arial Baltic"
	SetVariable RowNr,fSize=14,limits={0,inf,1},value= _NUM:0
	SetVariable OutName,pos={11,32},size={245,20},title="Output Name:",fSize=14
	SetVariable OutName,limits={-inf,inf,0},value= _STR:"Frib"
	Button DoSeperate,pos={55,58},size={166,26},proc=SepColumn,title="Seperate"
	Button DoSeperate,fSize=14,fStyle=1
EndMacro

Function SepColumn(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
			controlinfo DPool
			string PoolName=S_Value
			Controlinfo RowNr
			variable Item=V_Value
			Controlinfo OutName
			string ItemName=S_Value
			
			SepWaves(Poolname,item,ItemName)
			break
		case -1: // control being killed
			break
	endswitch

	return 0
End






function FoldersWaveMin(StX,EnX)
	variable StX,EnX    // Start and end points of mean
	
	string aW=wavelist("uImon*",";","")
	variable i
	make/n=(ItemsInList(aW)/2) WaveMini
	for(i=0;i<ItemsInList(aW);i+=2)
		wave w=$stringfromlist(i,aW)
		WaveMini[floor(i/2)]=wavemin(w,StX,EnX)
	endfor
end

Function BackCalcRb()
	wave Rb=$"RbProfile"
	variable i
	for(i=0;i<DimSize(RbProfile,0);i+=1)
		Rb[i][1]=Rb[i][1]/0.103
		Rb[i][2]=Rb[i][2]/0.103
		Rb[i][3]=Rb[i][3]/0.5
	endfor
	
end


